<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwimages="urn:WebWorks-Images-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwimaging="urn:WebWorks-XSLT-Extension-Imaging"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwsplits wwmode wwfiles wwdoc wwproject wwimages wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwimaging wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterImageTypesType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterDefaultPageExtension" />
 <xsl:param name="ParameterDefaultGraphicExtension" />


 <xsl:namespace-alias stylesheet-prefix="wwsplits" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwimages-types-by-name" match="wwimages:Type" use="@name" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Iterate input documents -->
   <!--                         -->
   <xsl:for-each select="$GlobalFiles[1]">
    <xsl:variable name="VarFilesByType" select="key('wwfiles-files-by-type', $ParameterDependsType)" />

    <xsl:value-of select="wwprogress:Start(count($VarFilesByType))" />

    <!-- Image types -->
    <!--             -->
    <xsl:variable name="VarImageTypesPath" select="key('wwfiles-files-by-type', $ParameterImageTypesType)[1]/@path" />
    <xsl:variable name="VarImageTypes" select="wwexsldoc:LoadXMLWithoutResolver($VarImageTypesPath)" />

    <xsl:for-each select="$VarFilesByType">
     <xsl:variable name="VarFile" select="." />

     <xsl:value-of select="wwprogress:Start(1)" />

     <!-- Call template -->
     <!--               -->
     <xsl:variable name="VarPath" select="wwfilesystem:Combine(wwfilesystem:GetDirectoryName($VarFile/@path), concat(translate($ParameterType, ':', '_'),'.xml'))" />

     <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, '', $VarFile/@groupID, '', $GlobalActionChecksum)" />
     <xsl:if test="not($VarUpToDate)">
      <xsl:variable name="VarResultAsXML">
       <!-- Load document -->
       <!--               -->
       <xsl:variable name="VarGroupNameInfo" select="wwexsldoc:LoadXMLWithoutResolver($VarFile/@path)" />

       <xsl:call-template name="Names">
        <xsl:with-param name="ParamGroupNameInfo" select="$VarGroupNameInfo" />
        <xsl:with-param name="ParamAllowedByReferenceTypes" select="$VarImageTypes" />
       </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
      <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarPath, 'utf-8', 'xml', '1.0', 'yes')" />
     </xsl:if>

     <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="" groupID="{$VarFile/@groupID}" documentID="" actionchecksum="{$GlobalActionChecksum}">
      <wwfiles:Depends path="{$VarFile/@path}" checksum="{$VarFile/@checksum}" groupID="{$VarFile/@groupID}" documentID="{$VarFile/@documentID}" />
     </wwfiles:File>

     <xsl:value-of select="wwprogress:End()" />
    </xsl:for-each>

    <xsl:value-of select="wwprogress:End()" />
   </xsl:for-each>

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="Names">
  <xsl:param name="ParamGroupNameInfo" />
  <xsl:param name="ParamAllowedByReferenceTypes" />

  <xsl:for-each select="$ParamGroupNameInfo/wwsplits:Splits">
   <xsl:variable name="VarSplits" select="." />

   <wwsplits:Splits>
    <xsl:copy-of select="$VarSplits/@*" />

    <xsl:for-each select="$VarSplits//wwsplits:Split">
     <xsl:variable name="VarSplit" select="." />

     <!-- Get page rule -->
     <!--               -->
     <xsl:variable name="VarPageStyleName">
      <xsl:call-template name="StyleName">
       <xsl:with-param name="ParamStyleNode" select="$VarSplit/wwsplits:PageStyle" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarPageRule" select="wwprojext:GetOverrideRule('Page', $VarPageStyleName, $VarSplit/@documentID, $VarSplit/@id)" />

     <!-- Generate output? -->
     <!--                  -->
     <xsl:variable name="VarPageGenerateOutputOption" select="$VarPageRule/wwproject:Options/wwproject:Option[@Name = 'generate-output']/@Value" />
     <xsl:variable name="VarPageGenerateOutput" select="(string-length($VarPageGenerateOutputOption) = 0) or ($VarPageGenerateOutputOption != 'false')" />

     <!-- Generate output? -->
     <!--                  -->
     <xsl:if test="$VarPageGenerateOutput">
      <!-- Get path -->
      <!--          -->
      <xsl:variable name="VarSplitPath">
       <xsl:call-template name="SplitPath">
        <xsl:with-param name="ParamSplit" select="$VarSplit" />
        <xsl:with-param name="ParamRule" select="$VarPageRule" />
       </xsl:call-template>
      </xsl:variable>

      <wwsplits:Split>
       <xsl:copy-of select="$VarSplit/@*" />
       <xsl:attribute name="path">
        <xsl:value-of select="$VarSplitPath" />
       </xsl:attribute>
       <xsl:attribute name="stylename">
        <xsl:value-of select="$VarPageStyleName" />
       </xsl:attribute>

       <xsl:for-each select="$VarSplit/wwsplits:Frames/wwsplits:Frame">
        <xsl:variable name="VarFrame" select="." />

        <!-- Get graphic rule -->
        <!--                  -->
        <xsl:variable name="VarOverrideRule" select="wwprojext:GetContextRule('Graphic', $VarFrame/wwdoc:Frame/@stylename, $VarSplit/@documentID, $VarFrame/wwdoc:Frame/@id)" />

        <!-- Generate output? -->
        <!--                  -->
        <xsl:variable name="VarGraphicGenerateOutputOption" select="$VarOverrideRule/wwproject:Options/wwproject:Option[@Name = 'generate-output']/@Value" />
        <xsl:variable name="VarGraphicGenerateOutput" select="(string-length($VarGraphicGenerateOutputOption) = 0) or ($VarGraphicGenerateOutputOption != 'false')" />

        <!-- Generate output? -->
        <!--                  -->
        <xsl:if test="$VarGraphicGenerateOutput">
         <!-- WIF structure allows for by reference graphic -->
         <!--                                               -->
         <!--  1. By reference facet and no nested content. -->
         <!--  2. Document only facet with nested content   -->
         <!--     containing only a single frame with a     -->
         <!--     by reference facet and no nested content. -->
         <!--                                               -->
         <xsl:variable name="VarWIFAllowsByReference">
          <xsl:choose>
           <!-- No nested content -->
           <!--                   -->
           <xsl:when test="(count($VarFrame/wwdoc:Frame/wwdoc:Content) = 0) or (count($VarFrame/wwdoc:Frame/wwdoc:Content/wwdoc:*) = 0)">
            <!-- By reference facet exists -->
            <!--                           -->
            <xsl:if test="count($VarFrame/wwdoc:Frame/wwdoc:Facets/wwdoc:Facet[@type = 'by-reference']) &gt; 0">
             <xsl:value-of select="true()" />
            </xsl:if>
           </xsl:when>

           <!-- Nested content exists -->
           <!--                       -->
           <xsl:otherwise>
            <!-- Only 'document' facets exist -->
            <!--                              -->
            <xsl:if test="count($VarFrame/wwdoc:Frame/wwdoc:Facets/wwdoc:Facet[@type = 'document']) = count($VarFrame/wwdoc:Frame/wwdoc:Facets/wwdoc:Facet)">
             <!-- Content contains a single frame only -->
             <!--                                      -->
             <xsl:variable name="VarContentNodes" select="$VarFrame/wwdoc:Frame/wwdoc:Content/wwdoc:*" />
             <xsl:if test="(count($VarContentNodes) = 1) and (local-name($VarContentNodes[1]) = 'Frame')">
              <xsl:variable name="VarNestedFrame" select="$VarContentNodes[1]" />

              <!-- Nested frame content is empty -->
              <!--                               -->
              <xsl:if test="(count($VarNestedFrame/wwdoc:Content) = 0) or (count($VarNestedFrame/wwdoc:Content/wwdoc:*) = 0)">
               <!-- By reference facet exists -->
               <!--                           -->
               <xsl:if test="count($VarNestedFrame/wwdoc:Facets/wwdoc:Facet[@type = 'by-reference']) &gt; 0">
                <xsl:value-of select="true()" />
               </xsl:if>
              </xsl:if>
             </xsl:if>
            </xsl:if>
           </xsl:otherwise>
          </xsl:choose>
         </xsl:variable>

         <!-- By reference source path -->
         <!--                          -->
         <xsl:variable name="VarByReferenceSourcePath">
          <xsl:choose>
           <xsl:when test="$VarWIFAllowsByReference = 'true'">
            <xsl:variable name="VarByReferenceFacets"  select="$VarFrame/wwdoc:Frame//wwdoc:Facet[@type = 'by-reference']" />
            <xsl:for-each select="$VarByReferenceFacets[1]">
             <xsl:variable name="VarByReferenceFacet" select="." />

             <xsl:value-of select="$VarByReferenceFacet/wwdoc:Attribute[@name = 'path']/@value" />
            </xsl:for-each>
           </xsl:when>

           <xsl:otherwise>
            <xsl:value-of select="''" />
           </xsl:otherwise>
          </xsl:choose>
         </xsl:variable>

         <!-- By reference frame requires:     -->
         <!--                                  -->
         <!--  1. by-reference facet           -->
         <!--  2. Supported image type         -->
         <!--  3. Within max width/height      -->
         <!--  4. Scaling = 100% or undefined  -->
         <!--                                  -->
         <xsl:variable name="VarByReference">
          <xsl:if test="$VarWIFAllowsByReference = 'true'">
           <!-- Rule allows by reference? -->
           <!--                           -->
           <xsl:variable name="VarAllowByReferenceGraphicsOption" select="$VarOverrideRule/wwproject:Options/wwproject:Option[@Name = 'by-reference-graphics']/@Value" />
           <xsl:if test="(string-length($VarAllowByReferenceGraphicsOption) = 0) or ($VarAllowByReferenceGraphicsOption = 'true')">
            <!-- Options allow by reference? -->
            <!--                             -->
            <xsl:variable name="VarMaxWidthOption" select="$VarOverrideRule/wwproject:Options/wwproject:Option[@Name = 'max-width']/@Value" />
            <xsl:variable name="VarMaxHeightOption" select="$VarOverrideRule/wwproject:Options/wwproject:Option[@Name = 'max-height']/@Value" />
            <xsl:variable name="VarScaleOption" select="$VarOverrideRule/wwproject:Options/wwproject:Option[@Name = 'scale']/@Value" />
            <xsl:if test="(string-length($VarScaleOption) = 0) or ($VarScaleOption = 'none') or (number($VarScaleOption) = 100)">
             <xsl:variable name="VarImageInfo" select="wwimaging:GetInfo($VarByReferenceSourcePath)" />
             <xsl:for-each select="$ParamAllowedByReferenceTypes[1]">
              <xsl:for-each select="key('wwimages-types-by-name', $VarImageInfo/@format)[1]">
               <xsl:variable name="VarWidth" select="number($VarImageInfo/@width)" />
               <xsl:variable name="VarHeight" select="number($VarImageInfo/@height)" />

               <xsl:choose>
                <xsl:when test="(string-length($VarMaxWidthOption) &gt; 0) and (string-length($VarMaxHeightOption) &gt; 0) and ($VarMaxWidthOption != 'none') and ($VarMaxHeightOption != 'none') and ((number($VarMaxWidthOption) &gt; 0) and (number($VarMaxHeightOption) &gt; 0))">
                 <xsl:choose>
                  <xsl:when test="($VarWidth &lt;= number($VarMaxWidthOption)) and ($VarHeight &lt;= number($VarMaxHeightOption))">
                   <xsl:value-of select="true()" />
                  </xsl:when>

                  <xsl:otherwise>
                   <xsl:value-of select="false()" />
                  </xsl:otherwise>
                 </xsl:choose>
                </xsl:when>

                <xsl:otherwise>
                 <xsl:value-of select="true()" />
                </xsl:otherwise>
               </xsl:choose>
              </xsl:for-each>
             </xsl:for-each>
            </xsl:if>
           </xsl:if>
          </xsl:if>
         </xsl:variable>

         <!-- Get path -->
         <!--          -->
         <xsl:variable name="VarFramePath">
          <xsl:choose>
           <xsl:when test="$VarByReference = 'true'">
            <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetDocumentGroupPath($VarSplit/@documentID))" />
            <xsl:variable name="VarImagesDirectoryPath" select="wwfilesystem:Combine($VarOutputDirectoryPath, 'images')" />
            <xsl:value-of select="wwfilesystem:Combine($VarImagesDirectoryPath, wwfilesystem:GetFileName($VarByReferenceSourcePath))" />
           </xsl:when>

           <xsl:otherwise>
            <xsl:call-template name="FramePath">
             <xsl:with-param name="ParamSplit" select="$VarSplit" />
             <xsl:with-param name="ParamFrame" select="$VarFrame" />
             <xsl:with-param name="ParamRule" select="$VarOverrideRule" />
            </xsl:call-template>
           </xsl:otherwise>
          </xsl:choose>
         </xsl:variable>

         <wwsplits:Frame>
          <xsl:attribute name="groupID">
           <xsl:value-of select="$VarSplit/@groupID" />
          </xsl:attribute>
          <xsl:attribute name="documentID">
           <xsl:value-of select="$VarSplit/@documentID" />
          </xsl:attribute>
          <xsl:copy-of select="$VarFrame/wwdoc:Frame/@*" />
          <xsl:copy-of select="$VarFrame/@*" />
          <xsl:if test="$VarByReference = 'true'">
           <xsl:attribute name="byref">
            <xsl:value-of select="'true'" />
           </xsl:attribute>
           <xsl:attribute name="source">
            <xsl:value-of select="$VarByReferenceSourcePath" />
           </xsl:attribute>
          </xsl:if>
          <xsl:attribute name="path">
           <xsl:value-of select="$VarFramePath" />
          </xsl:attribute>

          <!-- Thumbnail, wrapper, and description files -->
          <!--                                           -->
          <xsl:variable name="VarThumbnailPageRuleOption" select="$VarOverrideRule/wwproject:Options/wwproject:Option[@Name = 'thumbnail-page-rule']/@Value" />
          <wwsplits:Thumbnail>
           <xsl:attribute name="path">
            <xsl:variable name="VarFileName">
             <xsl:value-of select="wwfilesystem:GetFileNameWithoutExtension($VarFramePath)" />
             <xsl:text>_thumb</xsl:text>
             <xsl:value-of select="wwfilesystem:GetExtension($VarFramePath)" />
            </xsl:variable>

            <xsl:value-of select="wwfilesystem:Combine(wwfilesystem:GetDirectoryName($VarFramePath), $VarFileName)" />
           </xsl:attribute>
          </wwsplits:Thumbnail>
          <wwsplits:Wrapper groupID="{$VarSplit/@groupID}" documentID="{$VarSplit/@documentID}" stylename="{$VarThumbnailPageRuleOption}">
           <xsl:attribute name="path">
            <xsl:variable name="VarFileName">
             <xsl:value-of select="wwfilesystem:GetFileNameWithoutExtension($VarFramePath)" />
             <xsl:value-of select="$ParameterDefaultPageExtension" />
            </xsl:variable>

            <xsl:value-of select="wwfilesystem:Combine(wwfilesystem:GetDirectoryName($VarFramePath), $VarFileName)" />
           </xsl:attribute>
          </wwsplits:Wrapper>
          <wwsplits:Description>
           <xsl:attribute name="path">
            <xsl:variable name="VarFileName">
             <xsl:value-of select="wwfilesystem:GetFileNameWithoutExtension($VarFramePath)" />
             <xsl:text>.txt</xsl:text>
            </xsl:variable>

            <xsl:value-of select="wwfilesystem:Combine(wwfilesystem:GetDirectoryName($VarFramePath), $VarFileName)" />
           </xsl:attribute>
          </wwsplits:Description>
         </wwsplits:Frame>
        </xsl:if>
       </xsl:for-each>

       <!-- Copy over any popups -->
       <!--                      -->
       <xsl:variable name="VarPopups" select="$VarSplit/wwsplits:Popups/wwsplits:Popup" />
       <xsl:for-each select="$VarPopups">
        <xsl:variable name="VarPopup" select="." />

        <xsl:variable name="VarDocumentBaseName" select="wwfilesystem:GetFileNameWithoutExtension($VarSplit/wwsplits:Document/@path)" />
        <xsl:variable name="VarPopupFileName">
         <xsl:value-of select="$VarDocumentBaseName" />
         <xsl:text>-</xsl:text>
         <xsl:value-of select="$VarPopup/@id" />
         <xsl:value-of select="$ParameterDefaultPageExtension" />
        </xsl:variable>
        <xsl:variable name="VarPopupPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), $VarSplit/wwsplits:Group/@name, 'popups', $VarPopupFileName)" />

        <wwsplits:Popup>
         <xsl:copy-of select="$VarPopup/@*" />

         <xsl:attribute name="path">
          <xsl:value-of select="$VarPopupPath" />
         </xsl:attribute>
        </wwsplits:Popup>
       </xsl:for-each>
      </wwsplits:Split>
     </xsl:if>
    </xsl:for-each>

   </wwsplits:Splits>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="StyleName">
  <xsl:param name="ParamStyleNode" />

  <xsl:choose>
   <xsl:when test="count($ParamStyleNode[1]) = 1">
    <!-- Use requested style -->
    <!--                     -->
    <xsl:value-of select="$ParamStyleNode/@value" />
   </xsl:when>

   <xsl:otherwise>
    <!-- Force default rule -->
    <!--                    -->
    <xsl:value-of select="''" />
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="SplitPath">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamRule" />

  <!-- Gather file naming info -->
  <!--                         -->
  <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetDocumentGroupPath($ParamSplit/@documentID))" />
  <xsl:variable name="VarBaseFileName">
   <xsl:variable name="VarFileNameHint" select="$ParamSplit/wwsplits:FileName/@value" />
   <xsl:choose>
    <xsl:when test="string-length($VarFileNameHint) &gt; 0">
     <xsl:value-of select="$VarFileNameHint" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:value-of select="wwfilesystem:GetFileNameWithoutExtension($ParamSplit/wwsplits:Document/@path)" />
     <xsl:text>.</xsl:text>
     <xsl:value-of select="$ParamSplit/wwsplits:Document/@position" />
     <xsl:text>.</xsl:text>
     <xsl:value-of select="$ParamSplit/@position" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:variable name="VarExtensionOption" select="$ParamRule/wwproject:Options/wwproject:Option[@Name = 'file-extension']/@Value" />
  <xsl:variable name="VarExtension">
   <xsl:choose>
    <xsl:when test="string-length($VarExtensionOption) &gt; 0">
     <xsl:value-of select="$VarExtensionOption" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:value-of select="$ParameterDefaultPageExtension" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <xsl:variable name="VarName">
   <xsl:value-of select="$VarBaseFileName" />
   <xsl:value-of select="$VarExtension" />
  </xsl:variable>
  <xsl:variable name="VarPath" select="wwfilesystem:Combine($VarOutputDirectoryPath, wwfilesystem:MakeValidFileName($VarName))" />

  <xsl:value-of select="$VarPath" />
 </xsl:template>


 <xsl:template name="FramePath">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamFrame" />
  <xsl:param name="ParamRule" />

  <!-- Gather file naming info -->
  <!--                         -->
  <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetDocumentGroupPath($ParamSplit/@documentID))" />
  <xsl:variable name="VarImagesDirectoryPath" select="wwfilesystem:Combine($VarOutputDirectoryPath, 'images')" />
  <xsl:variable name="VarBaseFileName">
   <xsl:variable name="VarFileNameHint" select="$ParamFrame/wwsplits:FileName/@value" />
   <xsl:choose>
    <xsl:when test="string-length($VarFileNameHint) &gt; 0">
     <xsl:value-of select="$VarFileNameHint" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:value-of select="wwfilesystem:GetFileNameWithoutExtension($ParamSplit/wwsplits:Document/@path)" />
     <xsl:text>.</xsl:text>
     <xsl:value-of select="$ParamSplit/wwsplits:Document/@position" />
     <xsl:text>.</xsl:text>
     <xsl:value-of select="$ParamSplit/@position" />
     <xsl:text>.</xsl:text>
     <xsl:value-of select="$ParamFrame/@position" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:variable name="VarExtensionOption" select="$ParamRule/wwproject:Options/wwproject:Option[@Name = 'file-extension']/@Value" />
  <xsl:variable name="VarExtension">
   <xsl:choose>
    <xsl:when test="string-length($VarExtensionOption) &gt; 0">
     <xsl:value-of select="$VarExtensionOption" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:value-of select="$ParameterDefaultGraphicExtension" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <xsl:variable name="VarName">
   <xsl:value-of select="$VarBaseFileName" />
   <xsl:value-of select="$VarExtension" />
  </xsl:variable>
  <xsl:variable name="VarPath" select="wwfilesystem:Combine($VarImagesDirectoryPath, wwfilesystem:MakeValidFileName($VarName))" />

  <xsl:value-of select="$VarPath" />
 </xsl:template>
</xsl:stylesheet>
